<!DOCTYPE html>
@php
use Illuminate\Support\Str;
@endphp
<html dir="" lang="en">
<style>
  /* CSS */
  .select2-container--invalid .select2-selection {
    border-color: red;
  }

  /* active dropdown */

  .dropdown {
    position: relative;
    display: inline-block;
    color: white;
    /* padding: 15px; */
    font-size: 14px;
    border: none;
    padding-top: 12px;
    padding-bottom: 12px;
    padding-left: 14px;
    /* padding-right: 16px; */

  }

  .li {
    background-color: #EA6B00;
    color: white;
    /* padding: 15px; */
    font-size: 14px;
    border: none;
    padding-top: 12px;
    padding-bottom: 12px;
    padding-left: 14px;
    padding-right: 16px;
    cursor: pointer;
  }

  .dropdown-content {
    display: none;
    position: absolute;
    background-color: #FFEFE6;
    min-width: 160px;
    box-shadow: 0px 8px 16px 0px rgba(0, 0, 0, 0.2);
    z-index: 1;
    inset: 0px 240px auto;
    height: auto;
    width: 222px;
    padding-left: 8px;

  }

  .dropdown-content a {
    color: #5B5D6E;
    padding: 12px 16px;
    text-decoration: none;
    display: block;
    margin-top: 3px;
  }

  .dropdown-content a:hover {
    background-color: #FFEFE6;
    color: #EA6B00;
  }

  .dropdown:hover .dropdown-content {
    display: block;
  }

  .nav.side-menu>li.active,
  .nav.side-menu>li.current-page {
    /* border-right: 5px solid #1abb9c; */
    background-color: #FFFFFF;
  }

  .dropdown a {
    color: #454545;
  }

  .dropdown>a:hover {
    color: #454545;
  }

  .dropdown {
    color: #454545;
  }

  .nav.side-menu>li.active>.dropdown>a {
    -webkit-text-fill-color: #454545;
  }

  li.active:hover {
    color: #454545;
  }

  .nav.side-menu>li.active,
  .nav.side-menu>li.current-page>a {
    color: #454545;
    --bs-nav-link-hover-color: #454545;
  }

  span.titleup:hover {
    color: #333333;
  }

  .nav.toggle:hover {
    color: #595F69;
  }

  li>.dropdown>a {
    color: #FFFFFF;
  }

  li>.dropdown {
    color: #595F69;
  }

  .dropdown:hover {
    background-color: #FFFFFF;
    color: #454545;
    width: 240px;
  }

  .dropdown:hover>a {
    color: #454545;
  }

  /* --------- side dropdown menu in mobile screen ------------ */
  /* i.fa-solid.fa-sliders {
    margin-right: 15px;
  }

  i.fa-regular.fa-user {
    margin-right: 9px;
  }

  i.fa-solid.fa-car-side {
    margin-right: 10px;
  }

  i.fa-solid.fa-wrench {
    margin-right: 13px;
  }

  i.fa-solid.fa-receipt {
    margin-right: 17px;
  }

  i.fa-solid.fa-credit-card {
    margin-right: 12px;
  }

  i.fa-solid.fa-calculator {
    margin-right: 16px;
  }

  i.fa-solid.fa-tag {
    margin-right: 10px;
  }

  i.fa-solid.fa-clipboard-check {
    margin-right: 12px;
  }

  i.fa-solid.fa-envelope-open-text {
    margin-right: 12px;
  }

  i.fa-solid.fa-puzzle-piece {
    margin-right: 12px;
  }

  i.fa-solid.fa-code-branch {
    margin-right: 13px;
  }

  i.fa-solid.fa-file-lines {
    margin-right: 13px;
  }

  i.fa-solid.fa-gear {
    margin-right: 11px;
  } */

  .margin-right-10px {
    margin-right: 10px;
  }

  img.logout_img {
    margin-right: 5px;
  }
 @media (max-width:991px) {
  
  .side-menu li a.settingitem{
margin-left: -15px;
  }
  
 }
  @media (min-width: 280px) and (max-width: 540px) {

    .nav-sm .nav.child_menu li.active,
    .nav-sm .nav.side-menu li.active-sm {
      border-right: transparent;
    }

    /* .nav-sm .nav.side-menu li a i {
    font-size: 25px !important;
    text-align: center;
    width: 100% !important;
    margin-bottom: 5px;
} */
    .dropdown:hover {
      background-color: #FFFFFF;
      color: #454545;
      width: 72px;
    }

    i.fa-solid.fa-sliders {
      margin-left: -13px;
    }

    .dropdown-content {
      display: none;
      position: absolute;
      background-color: #FFEFE6;
      min-width: 160px;
      box-shadow: 0px 8px 16px 0px rgba(0, 0, 0, 0.2);
      z-index: 1;
      inset: 0px 324px auto;
      height: auto;
      width: 160px;
      padding-left: 1px;
      margin-left: -254px;
    }

    .nav-sm .nav.side-menu li a {
      text-align: left !important;
      font-weight: 400;
      font-size: 10px;
      padding: 10px 5px;
    }

    i.fa-regular.fa-user {
      margin-left: -14px;
    }

    i.fa-solid.fa-car-side {
      margin-left: -11px;
    }

    i.fa-solid.fa-credit-card {
      margin-left: -10px;
    }

    i.fa-solid.fa-calculator {
      margin-left: -12px;
    }

    i.fa-solid.fa-clipboard-check {
      margin-left: -4px;
    }
  }

  @media (min-width: 768px) and (max-width: 912px) {
    i.fa-solid.fa-sliders {
      margin-left: -12px;
    }

    .dropdown:hover {
      background-color: #FFFFFF;
      color: #454545;
      width: 70px;
    }

    .dropdown-content {
      display: none;
      position: absolute;
      background-color: #FFEFE6;
      min-width: 160px;
      box-shadow: 0px 8px 16px 0px rgba(0, 0, 0, 0.2);
      z-index: 1;
      inset: 0px 70px auto;
      height: auto;
      width: 160px;
    }

    .nav-sm .nav.side-menu li a {
      text-align: left !important;
      /* font-weight: 400;
    font-size: 10px;
    padding: 10px 5px; */
    }

    i.fa-regular.fa-user {
      margin-left: -12px;
    }

    i.fa-solid.fa-car-side {
      margin-left: -12px;
    }

    i.fa-solid.fa-credit-card {
      margin-left: -12px;
    }

    i.fa-solid.fa-calculator {
      margin-left: -12px;
    }
  }

  @media (min-width: 1024px) and (max-width: 1280px) {
    i.fa-solid.fa-sliders {
      margin-left: 0px;
    }

    .dropdown:hover {
      background-color: #FFFFFF;
      color: #454545;
      width: 72px;
    }

    .dropdown-content {
      display: none;
      position: absolute;
      background-color: #FFEFE6;
      min-width: 160px;
      box-shadow: 0px 8px 16px 0px rgba(0, 0, 0, 0.2);
      z-index: 1;
      inset: 0px 240px auto;
      height: auto;
      width: 222px;
      padding-left: 8px;
    }
  }
</style>

<head>
  <meta content="text/html; charset=UTF-8">
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- CSRF Token -->
  <meta name="csrf-token" content="{{ csrf_token() }}">

  <link rel="icon" href="{{ URL::asset('fevicol.png') }}" type="image/gif" sizes="16x16">
  <title>{{ getNameSystem() }}</title>

  <!-- Bootstrap -->
  <link href="{{ URL::asset('vendors/bootstrap/dist/css/bootstrap.min.css') }}" rel="stylesheet">
  <!-- Font Awesome  V6.1.1-->
  <link href="{{ URL::asset('vendors/font-awesome/css/fontawesome.min.css') }}" rel="stylesheet">
  <link href="{{ URL::asset('vendors/font-awesome/css/all.min.css') }}" rel="stylesheet">
  <!-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"> -->
  <link rel="stylesheet" href="{{ URL::asset('vendors/font-awesome/4.7.0/fontawesome.min.css') }}">
  <!-- NProgress -->
  <!-- <link href="{{ URL::asset('vendors/nprogress/nprogress.css') }}" rel="stylesheet"> -->

  <link href="{{ URL::asset('vendors/select2/css/select2.min.css') }}" rel="stylesheet">


  <!-- FullCalendar V5.11.0 -->
  <link href="{{ URL::asset('vendors/fullcalendar/lib/main.min.css') }}" rel="stylesheet">

  <!-- bootstrap-daterangepicker -->
  {{-- <link href="{{ URL::asset('vendors/bootstrap-daterangepicker/daterangepicker.css') }} "
  rel="stylesheet"> --}}
  {{-- <link href="{{ URL::asset('vendors/bootstrap-datetimepicker/build/css/bootstrap-datetimepicker.css') }}"
  rel="stylesheet"> --}}
  <link href="{{ URL::asset('vendors/bootstrap-date-time-picker/bootstrap5/css/bootstrap-datetimepicker.css') }}" rel="stylesheet">
  {{-- E:\xampp\htdocs\garagemaster_web\vendors\bootstrap-date-time-picker\bootstrap5\css\bootstrap-datetimepicker.css --}}
  <!-- dropify CSS -->
  <link rel="stylesheet" href="{{ URL::asset('vendors/dropify/css/dropify.min.css') }}">

  <!-- Custom Theme Style -->
  <link href="{{ URL::asset('build/css/custom.min.css') }} " rel="stylesheet">

  {{-- datatable js files of latest version --}}
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/datatables.net-buttons/js/dataTables.buttons.min.js') }}" defer="defer"></script>
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/datatables.net-buttons/js/buttons.bootstrap.min.js') }}" defer="defer"></script>
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/datatables.net-buttons/js/buttons.html5.min.js') }}" defer="defer"></script>
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/datatables.net-buttons/js/buttons.print.min.js') }}" defer="defer"></script>
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/datatables.net-fixedheader/js/dataTables.fixedHeader.min.js') }}" defer="defer"></script>
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/datatables.net-keytable/js/dataTables.keyTable.min.js') }}" defer="defer"></script>
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/datatables.net-scroller/js/scroller.dataTables.min.js') }}" defer="defer"></script>
  <script nonce="{{ $cspNonce }}"src="{!! URL::asset('public/vendor/pdfmake/js/vfs_fonts.min.js') !!}"></script>
  <script nonce="{{ $cspNonce }}"src="{!! URL::asset('public/vendor/pdfmake/js/pdfmake.min.js') !!}"></script>
  <script nonce="{{ $cspNonce }}"src="{!! URL::asset('public/vendor/pdfmake/js/Roboto.min.js') !!}"></script>

  <!-- Own Theme Style -->
  <link href="{{ URL::asset('build/css/own.css') }} " rel="stylesheet">


  <!-- Our Custom stylesheet -->
  <link rel="stylesheet" type="text/css" href="{{ URL::asset('public/css/responsive_styles.css') }}">

  <!-- MoT Custom stylesheet -->
  <link rel="stylesheet" type="text/css" href="{{ URL::asset('public/css/custom_mot_styles.css') }}">
  <!-- Datatables -->
  <!-- <link href="{{ URL::asset('https://code.jquery.com/jquery-3.5.1.js') }}" rel="stylesheet">
  <link href="{{ URL::asset('https://cdn.datatables.net/1.13.5/js/jquery.dataTables.min.js') }}" rel="stylesheet">
  <link href="{{ URL::asset('https://cdn.datatables.net/1.13.5/js/dataTables.bootstrap5.min.js') }}" rel="stylesheet"> -->

  <link href="{{ URL::asset('vendors/datatable/jquery-3.5.1.js') }}" type="text/js" rel="stylesheet">
  <link href="{{ URL::asset('vendors/datatable/jquery.dataTables.min.js') }}" type="text/js" rel="stylesheet">
  <link href="{{ URL::asset('vendors/datatable/dataTables.bootstrap5.min.js') }}" type="text/js" rel="stylesheet">
  <!-- Datatables -->

  <!-- AutoComplete CSS -->
  <link href="{{ URL::asset('build/css/themessmoothness.css') }}" rel="stylesheet">
  <!-- Multiselect CSS -->
  <link href="{{ URL::asset('build/css/multiselect.css') }}" rel="stylesheet">

  <!-- <link href='https://fonts.googleapis.com/css?family=Poppins' rel='stylesheet'> -->
  <link rel="stylesheet" href="{{ URL::asset('vendors/font-awesome/4.7.0/popins.css') }}">

  <link rel="stylesheet" type="text/css" href="{{ URL::asset('public/css/google_api_font.css') }}">
  @if (getValue() == 'rtl')
  <link href="{!! URL::asset('build/css/bootstrap-rtl.min.css') !!}" rel="stylesheet" id="rtl" />
  @else
  @endif

  <style>
    @media print {
      .noprint {
        display: none
      }
    }
  </style>
  <!-- colorpicker links -->
  <!-- <link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css" rel="stylesheet"> -->
  <!-- <script nonce="{{ $cspNonce }}"src="https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.js"></script>
  <script nonce="{{ $cspNonce }}"src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-colorpicker/2.3.3/css/bootstrap-colorpicker.min.css" rel="stylesheet">
  <script nonce="{{ $cspNonce }}"src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-colorpicker/2.3.3/js/bootstrap-colorpicker.min.js"></script> -->
  <link href="{{ URL::asset('vendors/bootstrap/dist/css/bootstrap-colorpicker.min.css') }}" rel="stylesheet">
  <script nonce="{{ $cspNonce }}"src="{{ asset('vendors/jquery/jquery.js') }}"></script>
  <!-- <script nonce="{{ $cspNonce }}"src="{{ asset('vendors/bootstrap/dist/js/bootstrap.min.js') }}"></script> -->
  <script nonce="{{ $cspNonce }}"src="{{ asset('vendors/bootstrap/dist/js/bootstrap-colorpicker.min.js') }}"></script>
  <script nonce="{{ $cspNonce }}" src="{{ asset('vendors/bootstrap/dist/js/bootstrap.bundle.min.js') }}"></script>

</head>
<?php
$langcode = getLangCode();

$baseUrl = url('/');
$currentUrl = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
$currentRoute = str_replace($baseUrl, "", $currentUrl);
?>

<body id="app-layout" class="nav-md <?php echo getValue(); ?>">
  <div class="container body">
    <div class="main_container">
      <div class="col-md-3 left_col">
        <div class="left_col scroll-view">
          <div class="navbar nav_title d-none d-sm-block LogoMenuIcon py-0" style="border: 0;">
            <a href="{!! url('/') !!}" class="site_title mb-0">
              <img src="{{ URL::asset('public/general_setting/' . getLogoSystem()) }}" class="profilepic">
            </a>
          </div>

          <div class="clearfix"></div>

          <!-- sidebar menu -->
          <div id="sidebar-menu" class="main_menu_side hidden-print main_menu">
            <div class="menu_section">
              <ul class="nav side-menu">
                @if(Request::is('domain'))
                <li class="w-100 active"><a href="{!! url('/domain') !!}"><i class="fa-solid fa-gear margin-right-10px"></i>{{ trans('License Settings') }}</a></li>
                @endif

                @php
                $inventoryRoutes = ['/'];
                @endphp

                <!-- <img src="{{ URL::asset('public/img/icons/dashboard.png') }}" > -->
                <li class={{in_array($currentRoute,$inventoryRoutes) ? 'active' : ''}}><a href="{!! url('/') !!}"><i class="fa-solid fa-house margin-right-10px"></i>{{ trans('message.Dashboard') }}
                  </a></li>

                @canany(['supplier_view', 'product_view', 'purchase_view', 'stock_view'])
                @php
                $inventoryRoutes = ['/supplier/list','/product/list','/purchase/list','/stoke/list','/supplier/add','/product/add','/purchase/add','/stoke/add','/supplier/list/edit/'];
                @endphp
                <li class="{{ in_array($currentRoute, $inventoryRoutes) || Str::startsWith($currentRoute, '/supplier/list/') || Str::startsWith($currentRoute, '/product/list/edit/') || Str::startsWith($currentRoute, '/purchase/list/edit/') ? 'active' : '' }}">

                  <div class="dropdown w-100">
                    <a href="#"><i class="fa-solid fa-sliders margin-right-10px"></i> {{ trans('message.Inventory') }}<span class="fa fa-chevron-right dropdown-right-icon icon"> </span></a>
                    <div class="dropdown-content">
                      @can('supplier_view')
                      <a href="{!! url('/supplier/list') !!}">{{ trans('message.Supplier') }}</a>
                      @endcan

                      @can('product_view')
                      <a href="{!! url('/product/list') !!}">{{ trans('message.Product') }}</a>
                      @endcan

                      @can('purchase_view')
                      <a href="{!! url('/purchase/list') !!}">{{ trans('message.Purchase') }}</a>
                      @endcan

                      @can('stock_view')
                      <a href="{!! url('/stoke/list') !!}">{{ trans('message.Stock') }}</a>
                      @endcan
                    </div>
                  </div>
                </li>
                @endcanany

                @canany(['customer_view', 'employee_view', 'supportstaff_view', 'accountant_view', 'branchAdmin_view'])
                @php
                $inventoryRoutes = ['/customer/list','/employee/list','/supportstaff/list','/accountant/list','/branchadmin/list','/customer/add','/employee/add','/supportstaff/add','/accountant/add','/branchadmin/add'];
                @endphp
                <li class="{{ in_array($currentRoute, $inventoryRoutes) || Str::startsWith($currentRoute, '/customer/list/') || Str::startsWith($currentRoute, '/employee/view/') || Str::startsWith($currentRoute, '/employee/edit/') || Str::startsWith($currentRoute, '/supportstaff/list/') || Str::startsWith($currentRoute, '/accountant/list/') || Str::startsWith($currentRoute, '/branchadmin/list/') ? 'active' : '' }}">

                  <div class="dropdown w-100">
                    <a href="#"><i class="fa-regular fa-user margin-right-10px"></i> {{ trans('message.Users') }}<span class="fa fa-chevron-right dropdown-right-icon icon"> </span></a>
                    <div class="dropdown-content dropdown-content-user">
                      @can('customer_view')
                      <a href="{!! url('/customer/list')!!}">{{ trans('message.Customers') }}</a>
                      @endcan

                      @can('employee_view')
                      <a href="{!! url('/employee/list') !!}">{{ trans('message.Employees') }}</a>
                      @endcan

                      @can('supportstaff_view')
                      <a href="{!! url('/supportstaff/list') !!}">{{ trans('message.Support Staff') }}</a>
                      @endcan

                      @can('accountant_view')
                      <a href="{!! url('/accountant/list') !!}">{{ trans('message.Accountant') }}</a>
                      @endcan

                      @can('branchAdmin_view')
                      <a href="{!! url('/branchadmin/list') !!}">{{ trans('message.Branch Admin') }}</a>
                      @endcan

                    </div>
                  </div>
                </li>
                @endcanany

                @canany(['vehicle_view', 'vehicletype_view', 'vehiclebrand_view', 'colors_view'])
                @php
                $inventoryRoutes = ['/vehicle/list','/vehicletype/list','/vehiclebrand/list','/color/list','/vehicle/add','/vehicletype/vehicletypeadd','/vehiclebrand/add','/color/add'];
                @endphp
                <li class="{{ in_array($currentRoute, $inventoryRoutes) || Str::startsWith($currentRoute, '/vehicle/list') || Str::startsWith($currentRoute, '/vehicletype/list/') || Str::startsWith($currentRoute, '/vehiclebrand/list/') || Str::startsWith($currentRoute, '/color/list/edit/') ? 'active' : '' }}">

                  <div class="dropdown w-100">
                    <a href="#"><i class="fa-solid fa-car-side margin-right-10px"></i>{{ trans('message.Vehicles') }}<span class="fa fa-chevron-right dropdown-right-icon icon"> </span></a>
                    <div class="dropdown-content dropdown-content-vehicle ">
                      @can('vehicle_view')
                      <a href="{!! url('/vehicle/list')!!}">{{ trans('message.List Vehicle') }}</a>
                      @endcan

                      @can('vehicletype_view')
                      <a href="{!! url('/vehicletype/list') !!}">{{ trans('message.List Vehicle Type') }}</a>
                      @endcan

                      @can('vehiclebrand_view')
                      <a href="{!! url('/vehiclebrand/list') !!}">{{ trans('message.List Vehicle Brand') }}</a>
                      @endcan

                      @can('vehiclemodel_view')
                      <a href="{!! url('/vehicalmodel/list') !!}">{{ trans('message.List Vehicle Model') }}</a>
                      @endcan

                      @can('colors_view')
                      <a href="{!! url('/color/list') !!}">{{ trans('message.Colors') }}</a>
                      @endcan
                    </div>
                  </div>
                </li>
                @endcanany

                @php
                $inventoryRoutes = ['/service/list','/service/add'];
                @endphp
                @can('service_view')
                <li class="{{ in_array($currentRoute, $inventoryRoutes) || Str::startsWith($currentRoute, '/service/list/') ? 'active' : '' }}"><a href="{!! url('/service/list') !!}"><i class="fa-solid fa-wrench margin-right-10px"></i>{{ trans('message.Services') }}</a></li>
                @endcan

                @php
                $inventoryRoutes = ['/quotation/list','/quotation/add'];
                @endphp
                @can('quotation_view')
                <li class="{{ in_array($currentRoute, $inventoryRoutes) || Str::startsWith($currentRoute, '/quotation/list/') ? 'active' : '' }}">
                  <a href="{!! url('/quotation/list') !!}"><i class="fa-solid fa-file-invoice-dollar margin-right-10px"></i> {{ trans('message.Quotation') }}
                  </a>
                </li>
                @endcan

                @php
                $inventoryRoutes = ['/invoice/list','/invoice/add','/invoice/sale_part'];
                @endphp
                @can('invoice_view')
                <li class="{{ in_array($currentRoute, $inventoryRoutes) || Str::startsWith($currentRoute, '/invoice/') ? 'active' : '' }}"><a href="{!! url('/invoice/list') !!}"><i class="fa-solid fa-receipt margin-right-10px"></i> {{ trans('message.Invoices') }}</a></li>
                @endcan

                @canany(['jobcard_view', 'gatepass_view'])
                @php
                $inventoryRoutes = ['/jobcard/list','/gatepass/list','/gatepass/add'];
                @endphp
                <li class="{{ in_array($currentRoute, $inventoryRoutes) || Str::startsWith($currentRoute, '/jobcard/') || Str::startsWith($currentRoute, '/gatepass/') ? 'active' : '' }}">
                  <div class="dropdown w-100">
                    <a href="#"><i class="fa-solid fa-credit-card margin-right-10px"></i>{{ trans('message.Job Card') }}<span class="fa fa-chevron-right dropdown-right-icon icon"></span></a>
                    <div class="dropdown-content dropdown-content-jobcard">
                      @can('jobcard_view')
                      <a href="{!! url('/jobcard/list') !!}">{{ trans('message.Job Card') }}</a>
                      @endcan
                      @can('gatepass_view')
                      <a href="{!! url('/gatepass/list') !!}">{{ trans('message.Gate Pass') }}</a>
                      @endcan
                    </div>
                  </div>
                </li>
                @endcanany

                @canany(['taxrate_view', 'paymentmethod_view', 'income_view', 'expense_view'])
                @php
                $inventoryRoutes = ['/taxrates/list','/payment/list','/income/list','/expense/list','/taxrates/add','/payment/add','/income/add','/income/month_income','/expense/add','/expense/month_expense'];
                @endphp
                <li class="{{ in_array($currentRoute, $inventoryRoutes) || Str::startsWith($currentRoute, '/taxrates/') || Str::startsWith($currentRoute, '/payment/') || Str::startsWith($currentRoute, '/income/') || Str::startsWith($currentRoute, '/expense/') ? 'active' : '' }}">
                  <div class="dropdown w-100">
                    <a href="#"><i class="fa-solid fa-calculator margin-right-10px"></i> {{trans('message.Accounts')}}<span class="fa fa-chevron-right dropdown-right-icon icon"></span></a>
                    <div class="dropdown-content">
                      @can('taxrate_view')
                      <a href="{!! url('/taxrates/list') !!}">{{ trans('message.List Tax Rates') }}</a>
                      @endcan

                      @can('paymentmethod_view')
                      <a href="{!! url('/payment/list') !!}">{{ trans('message.List Payment Method') }}</a>
                      @endcan

                      @can('income_view')
                      <a href="{!! url('/income/list') !!}">{{ trans('message.Income') }}</a>
                      @endcan

                      @can('expense_view')
                      <a href="{!! url('/expense/list') !!}">{{ trans('message.Expenses') }}</a>
                      @endcan
                    </div>
                  </div>
                </li>
                @endcanany

                <!-- @php
                $inventoryRoutes = ['/sales/list','/sales/add'];
                @endphp
                @can('sales_view')
                <li class="{{in_array($currentRoute,$inventoryRoutes) || Str::startsWith($currentRoute, '/sales/') ? 'active' : ''}}"><a href="{!! url('/sales/list') !!}"><i class="fa-solid fa-tag"></i>
                    @if (Auth::user()->role == 'Customer')
                    {{ trans('message.Vehicle Purchased') }}
                    @else
                    {{ trans('message.Vehicle Sells') }}
                    @endif
                  </a> </li>
                @endcan -->

                @php
                $inventoryRoutes = ['/sales_part/list','/sales_part/add'];
                @endphp
                @can('salespart_view')
                @if (getActiveCustomer(Auth::user()->id) == 'yes' || getActiveEmployee(Auth::user()->id) == 'yes' || getBranchadminsactive(Auth::user()->id) == 'yes')
                <li class="{{in_array($currentRoute,$inventoryRoutes) || Str::startsWith($currentRoute, '/sales_part/') ? 'active' : ''}}"><a href="{!! url('/sales_part/list') !!}"><i class="fa-solid fa-tag margin-right-10px"></i> {{ trans('message.Part Sells') }} </a> </li>
                @else
                <li class="{{in_array($currentRoute,$inventoryRoutes) || Str::startsWith($currentRoute, '/sales_part/') ? 'active' : ''}}"><a href="{!! url('/sales_part/list') !!}"><i class="fa-solid fa-tag margin-right-10px"></i> {{ trans('message.Purchase') }} </a> </li>
                @endif
                @endcan

                @php
                $inventoryRoutes = ['/rto/list','/rto/add'];
                @endphp
                @can('rto_view')
                <li class="{{in_array($currentRoute,$inventoryRoutes) || Str::startsWith($currentRoute, '/rto/') ?  'active' : ''}}"><a href="{!! url('/rto/list') !!}"><i class="fa-solid fa-clipboard-check margin-right-10px"></i> {{ trans('message.Compliance') }}</a>
                </li>
                @endcan

                @php
                $inventoryRoutes = ['/report/salesreport','/report/servicereport','/report/productreport','/report/productuses','/report/servicebyemployee'];
                @endphp
                @can('report_view')
                <li class="{{in_array($currentRoute,$inventoryRoutes)  || Str::startsWith($currentRoute, '/report/')? 'active' : ''}}"><a href="{!! url('/report/servicereport') !!}"><i class="fa-solid fa-chart-line margin-right-10px"></i>{{ trans('message.Reports') }}
                  </a></li>
                @endcan

                @can('emailtemplate_view')
                <li class="w-100"><a href="{!! url('/mail/mail') !!}"><i class="fa-solid fa-envelope-open-text margin-right-10px"></i>{{ trans('message.Email Templates') }}</a></li>
                @endcan

                @php
                $inventoryRoutes = ['/setting/custom/list','/setting/custom/add'];
                @endphp
                @can('customfield_view')
                <li class="{{in_array($currentRoute,$inventoryRoutes) || Str::startsWith($currentRoute, '/setting/custom/') ? 'active' : ''}}"><a href="{!! url('/setting/custom/list') !!}"><i class="fa-solid fa-puzzle-piece margin-right-10px"></i>{{ trans('message.Custom Fields') }}</a> </li>
                @endcan

                @php
                $inventoryRoutes = ['/observation/list','/observation/add'];
                @endphp
                @can('observationlibrary_view')
                <li class="{{in_array($currentRoute,$inventoryRoutes) ? 'active' : ''}}"><a href="{!! url('/observation/list') !!}"><i class="fa-solid fa-file-lines margin-right-10px"></i> {{ trans('message.Observation library') }}</a></li>
                @endcan

                @php
                $inventoryRoutes = ['/notes/list','/notes/add'];
                @endphp
                @can('notes_view')
                <li class="{{in_array($currentRoute,$inventoryRoutes) ? 'active' : ''}}"><a href="{!! url('/notes/list') !!}"><i class="fa-solid fa-pen-to-square margin-right-10px"></i> {{ trans('message.Notes') }}</a></li>
                @endcan

                @php
                $inventoryRoutes = ['/branch/list','/branch/add'];
                @endphp
                @can('branch_view')
                <li class="{{in_array($currentRoute,$inventoryRoutes) || Str::startsWith($currentRoute, '/branch/') ? 'active' : ''}}"><a href="{!! url('/branch/list') !!}"><i class="fa-solid fa-code-branch margin-right-10px"></i> {{ trans('message.Branch') }}
                  </a>
                </li>
                @endcan

                @php
                $helpdocumentroute = ['/helpdocument/list'];
                @endphp
               
                <li class="{{in_array($currentRoute,$helpdocumentroute) || Str::startsWith($currentRoute, '/helpdocument/') ? 'active' : ''}}"><a href="{!! url('/helpdocument/list') !!}"><i class="fa-solid fa-file margin-right-10px"></i> {{ trans('message.Help Document') }}
                  </a>
                </li>
              
                @php
                $inventoryRoutes = ['/setting/general_setting/list','/setting/timezone/list','/setting/accessrights/show','/setting/hours/list','/setting/stripe/list','/branch_setting/list','/setting/payment-gateways/list','/how-to-videos','/addons'];
                @endphp
                @if (getActiveAdmin(Auth::User()->id) == 'yes')
                <li class="{{ in_array($currentRoute, $inventoryRoutes) || Str::startsWith($currentRoute, '/setting/general_setting/list') || Str::startsWith($currentRoute, '/addons') || Str::startsWith($currentRoute, '/how-to-videos') ? 'active' : '' }}">
                  <div class="dropdown w-100 ">
                    <a href="javascript:void(0);" class="settingitem" ><i class="fa-solid fa-gear margin-right-10px"></i> {{ trans('message.Settings') }}
                      <span class="fa fa-chevron-right dropdown-right-icon icon"></span>
                  </a>
                      <div class="dropdown-content">
                          <a href="{!! url('/setting/general_setting/list') !!}">{{ trans('message.General Settings') }}</a>
                          <a href="{!! url('/addons') !!}">{{ trans('message.Addons') }}</a>
                          <a href="{!! url('/how-to-videos') !!}">{{ trans('message.How To Videos') }}</a>
                      </div>
                  </div>
              </li>
                @else
                @if (Gate::allows('generalsetting_view'))
                @can('generalsetting_view')
                <li class="{{ in_array($currentRoute, $inventoryRoutes) || Str::startsWith($currentRoute, '/setting/general_setting/list') || Str::startsWith($currentRoute, '/how-to-videos') ? 'active' : '' }}">
                  <div class="dropdown w-100">
                    <a href="javascript:void(0);" class="settingitem" ><i class="fa-solid fa-gear margin-right-10px"></i> {{ trans('message.Settings') }}
                      <span class="fa fa-chevron-right dropdown-right-icon icon"></span>
                  </a>
                      <div class="dropdown-content">
                          <a href="{!! url('/setting/general_setting/list') !!}">{{ trans('message.General Settings') }}</a>
                          <a href="{!! url('/how-to-videos') !!}">{{ trans('message.How To Videos') }}</a>
                      </div>
                  </div>
              </li>
                @endcan
                @else
                @can('timezone_view')
                <li class="{{ in_array($currentRoute, $inventoryRoutes) || Str::startsWith($currentRoute, '/setting/timezone/list') || Str::startsWith($currentRoute, '/how-to-videos') ? 'active' : '' }}">
                  <div class="dropdown w-100">
                      <a href="javascript:void(0);" class="settingitem" ><i class="fa-solid fa-gear margin-right-10px"></i> {{ trans('message.Settings') }}
                          <span class="fa fa-chevron-right dropdown-right-icon icon"></span>
                      </a>
                      <div class="dropdown-content">
                          <a href="{!! url('/setting/timezone/list') !!}">{{ trans('message.General Settings') }}</a>
                          <a href="{!! url('/how-to-videos') !!}">{{ trans('message.How To Videos') }}</a>
                      </div>
                  </div>
              </li>
                @endcan
                @endif
                @endif
                <li>
                  <a class="logoutConfirm margin-right-10px"><i class="fa fa-power-off" aria-hidden="true"></i>{{ trans('message.Logout') }}</a>
                  <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                    @csrf
                  </form>
                  <!-- <a title="{{trans('message.Logout')}}" href="#" onclick="event.preventDefault();document.getElementById('logout-form').submit();">
                  <i class="fa fa-power-off" aria-hidden="true"></i>{{trans('message.Logout')}}
                  <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                    @csrf
                  </form>
                </a> -->
                </li>
              </ul>
              <nav aria-label="Page navigation example">

            </div>
          </div>

          <!-- /sidebar menu -->

        </div>
      </div>

      <!-- top navigation -->
      <div class="top_nav position-relative">

        <!-- /top navigation -->
        <?php 
        $version = Cache::get('version', function () {
        return DB::table('tbl_settings')->value('version');
       });
       $systemName = Cache::get('system_name', function () {
        return DB::table('tbl_settings')->value('system_name');
        });
        $year = date('Y');
        ?>
        @yield('content')
        <footer class="footerforallpage bottom-0 bg-white text-center" id="footerforid">
         <span class="footerbottom me-3">{{ trans('message.Copyright') }} {{ $year }} | {{ $systemName }} | {{ trans('message.All Rights Reserved') }} | {{trans('message.Version')}} {{$version}} | <a href="https://mojoomla.com/product/garage-master-garage-management-system">{{trans('message.Powered By GarageMaster')}}</a></span>
        </footer>                        
      </div>
    </div>
  </div>

  <!-- jQuery -->
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/jquery/dist/jquery.min.js') }}"></script>
  <!-- New appended notes rows translation -->
  <script nonce="{{ $cspNonce }}">
  const translations = @json([
    'note' => trans('message.Notes'),
    'internal_notes' => trans('message.Internal Notes'),
  ]);
</script>
  <!-- <script nonce="{{ $cspNonce }}"src="{{ URL::asset('build/js/jquery-ui.js') }}" defer="defer"></script> -->


  <!-- Bootstrap -->
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('build/js/popper.min.js') }}" defer="defer"></script>

  <!-- {{-- <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/bootstrap/dist/js/bootstrap.min.js') }}"
  defer="defer"></script> --}} -->

  <!-- <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/bootstrap/dist/js/bootstrap.bundle.js') }}" defer="defer"></script> -->


  <!-- NProgress -->
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/nprogress/nprogress.js') }}" defer="defer"></script>

  <!-- DateJS for theme default js-->
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/DateJS/build/date.js') }}" defer="defer"></script>

  <!-- Custom Theme Scripts -->
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('build/js/custom.min.js') }}" defer="defer"></script>
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/sweetalert/dist/sweetalert.min.js') }}" defer="defer"></script>

  <!-- <script nonce="{{ $cspNonce }}"src="https://cdn.datatables.net/v/bs5/jqc-1.12.4/dt-1.13.4/datatables.min.js"></script> -->
  <script nonce="{{ $cspNonce }}"type="text/javascript" src="{{ URL::asset('vendors/datatable/datatables.min.js') }}"></script>


  <!-- dropify scripts-->
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/dropify/js/dropify.min.js') }}" defer="defer"></script>

  <!-- bootstrap-daterangepicker -->
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/moment/moment.min.js') }}" defer="defer"></script>
  {{-- <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/bootstrap-datetimepicker/build/js/bootstrap-datetimepicker.min.js') }}"
  defer="defer"></script> --}}
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/bootstrap-date-time-picker/bootstrap5/js/bootstrap-datetimepicker.min.js') }}" defer="defer"></script>
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('/vendors/bootstrap-date-time-picker/bootstrap5/js/locales/bootstrap-datetimepicker.' . getLangCode() . '.js') }}" defer="defer"></script>

  {{-- <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/bootstrap-daterangepicker/daterangepicker.js') }}"
  defer="defer"></script> --}}

  <!-- Filter  -->
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/jszip/dist/jszip.min.js') }}" defer="defer"></script>

  <!-- Autocomplete Js  -->
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('build/js/jquery.circliful.min.js') }}" defer="defer"></script>

  <!-- Multiselect Js  -->
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('build/js/bootstrap-multiselect.js') }}" defer="defer"></script>
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('vendors/select2/js/select2.min.js') }}" type='text/javascript' defer="defer"></script>

  <!-- For form field validate Using Proengsoft -->
  <script nonce="{{ $cspNonce }}"type="text/javascript" src="{{ URL::asset('build/jquery-validate/1.19.2/jquery.validate.min.js') }}"></script>


  <script nonce="{{ $cspNonce }}"type="text/javascript">
    $(document).ready(function() {
      $('form').bind("keypress", function(e) {
        if (e.keyCode == 13) {
          e.preventDefault();
          return false;
        }
      });

      $('body').on('click', '.logoutConfirm', function() {
        var msg1 = "{{ trans('message.Are You Sure?') }}";
        var msg2 = "{{ trans('message.You will be logged out!') }}";
        var msg3 = "{{ trans('message.Cancel') }}";
        var msg4 = "{{ trans('message.Yes') }}";

        swal({
          title: msg1,
          text: msg2,
          icon: 'warning',
          cancelButtonColor: '#C1C1C1',
          buttons: [msg3, msg4],
          dangerMode: true,
        }).then((willDelete) => {
          if (willDelete) {
            event.preventDefault();
            document.getElementById('logout-form').submit();
          }
        });
      });
    });

    var csrf_token = document.querySelector("meta[name='csrf-token']").getAttribute("content");

    function csrfSafeMethod(method) {
      // these HTTP methods do not require CSRF protection
      return (/^(GET|HEAD|OPTIONS)$/.test(method));
    }
    var o = XMLHttpRequest.prototype.open;
    XMLHttpRequest.prototype.open = function() {
      var res = o.apply(this, arguments);
      var err = new Error();
      if (!csrfSafeMethod(arguments[0])) {
        this.setRequestHeader('anti-csrf-token', csrf_token);
      }
      return res;
    };
  </script>

  <!-- Delete multiple rows -->
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('public/js/custom/accessrights/deletemultiple.js') }}"></script>

  <!-- Add multiple notes -->
  <script nonce="{{ $cspNonce }}"src="{{ URL::asset('public/js/custom/accessrights/notes.js') }}"></script>

  <!-- For scroll active tab -->
  <script nonce="{{ $cspNonce }}">
    var activeElement = document.querySelector('.nav-tabs .nav-link.active');

    if (activeElement) {
      activeElement.scrollIntoView({
        behavior: 'smooth',
        block: 'end'
      });
    }

    $(document).ready(function() {
      var csrfToken = $('meta[name="csrf-token"]').attr('content');
      var checkedCount = 0;
      var checkboxes = $('input[name="chk"]');
      var totalRows = $('table tbody tr').length;
      var selectAll = $('input[name="selectAll"]');


      $('#select-all-btn').click(function() {
        var checkboxes = $('input[name="chk"]');
        checkboxes.prop('checked', !checkboxes.prop('checked'));
      });

      checkboxes.change(function() {
        // Update checkedCount every time a checkbox changes
        checkedCount = checkboxes.filter(':checked').length;
        if (checkedCount === totalRows) {
          selectAll.prop('checked', true); // Set the "Select All" checkbox to true
        } else {
          selectAll.prop('checked', false); // Set the "Select All" checkbox to false if not all checkboxes are checked
        }
      });

      $('#delete-selected-btn').click(function() {
        var selectedIds = [];
        var deleteUrl = $(this).data('url');

        $('input[name="chk"]:checked').each(function() {
          selectedIds.push($(this).closest('tr').data('user-id'));
        });

        if (selectedIds.length === 0) {
          swal({
            title: "{{ trans('message.Please select atleast one record') }}",
            icon: 'warning',
            button: "{{ trans('message.OK') }}",
            dangerMode: true,
          });
          return;
        } else {
          var msg1 = "{{ trans('message.Are You Sure?') }}";
          var msg2 = "{{ trans('message.You will not be able to recover this data afterwards!') }}";
          var msg3 = "{{ trans('message.Cancel') }}";
          var msg4 = "{{ trans('message.Yes, delete!') }}";

          swal({
            title: msg1,
            text: msg2,
            icon: 'warning',
            cancelButtonColor: '#C1C1C1',
            buttons: [msg3, msg4],
            dangerMode: true,
          }).then((willDelete) => {
            if (willDelete) {
              $.ajax({
                url: deleteUrl,
                method: 'POST',
                data: {
                  _token: csrfToken,
                  ids: selectedIds
                },
                success: function(response) {
                  selectedIds.forEach(function(id) {
                    $('tr[data-user-id="' + id + '"]').remove();
                  });
                  location.reload();
                },
                error: function() {
                  alert('An error occurred while deleting selected rows.');
                }
              });
            }
          });
        }
      });
    });
  </script>
</body>

</html>